SPACE=420
;***********************************
;** OCCUPIED REGS.: A5,A6         **
;** (C) 1990 STalin OF F.F.       **
;***********************************

EXEC=0             ;-1 FOR EXECUTABLE

 IFEQ EXEC,-1
SCR1=$70000
 ELSE
SCR1=$F0000
 ENDIF
SCR2=SCR1+$8000

 JMP START

BUFF:
 DS.B 2500,0

VBL:
 MOVE.B SCREENS+1(PC),$FF8201
 MOVE.B SCREENS+2(PC),$FF8203
 ST SYNCF
 MOVEM.L D0-D7/A0-A4,-(SP)
 MOVE.W #$000,(A6)

CPEK:
 LEA COLTAB+400,A5
 SUBQ.W #2,A5
 CMP.L #COLTAB,A5
 BNE.S CC1
   LEA COLTAB+400(PC),A5
CC1:
 MOVE.L A5,CPEK+2
   MOVE.L SCOLA(PC),A0
   MOVE.W SCOL(PC),(A0)
 LEA 398(A5),A0
 MOVE.W (A0),SCOL
 MOVE.L A0,SCOLA
 MOVE.W #0,(A0)

   MOVEM.L A5-A6,-(SP)
   LEA MUSIC(PC),A3
   JSR MUSIC+350(PC)
   MOVEM.L (SP)+,A5-A6

 MOVE.L #$07610761,D0
 LEA 16(A6),A0
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)

 MOVEM.L (SP)+,D0-D7/A0-A4
 MOVE.L #RASTER1,$120
 CLR.B $FFFA1B
 MOVE.B #1,$FFFA21
 MOVE.B #8,$FFFA1B
 RTE
SCOL: DC.W 0
SCOLA: DC.L BUFF
SYNCF: DC.W 0


MAIN:
 TST.B SYNCF
 BEQ.S MAIN
 CLR.B SYNCF

 JSR FLEXSCREEN(PC)
 JSR SCROLLS(PC)
 JSR SECONDSCROLL(PC)
 JSR BLACKFF(PC)
 JSR LOGO(PC)
 JSR THIRDSCROLL(PC)
 JSR PLANES(PC)
  JSR BLACKSPRITES(PC) ;
  JSR SPRITES(PC)      ;

 MOVE.L SCREENS(PC),D0
 MOVE.L SCREENS+4(PC),D1
 EXG.L D0,D1
 MOVE.L D0,SCREENS
 MOVE.L D1,SCREENS+4

 IFEQ EXEC,0
   MOVE.W #$777,(A6)
 ENDIF

 MOVE.B $FFFC02,D0
 IFEQ EXEC,0
   CMP.B #$66,D0
 ELSE
   CMP.B #$39,D0
 ENDIF
 BEQ EXIT

 BRA.S MAIN


THIRDSCROLL:  ;PEK!
 LEA TEXTBUF3,A0
 MOVE.L SCREENS(PC),A1
N@=0
L@=8*160+12
 REPEAT
   MOVE.B (A0)+,D0
   MOVE.B D0,L@(A1)
   MOVE.B D0,L@+96(A1)
   MOVE.B D0,L@+144(A1)
N@=N@+1
L@=L@+160
 UNTILEQ N@,180

EPEK1:   ;PEK!
 CMP.L #0,A0
 BNE.S TS1
   MOVE.L #TEXTBUF3,THIRDSCROLL+2
TS1:
 ADDQ.L #1,THIRDSCROLL+2
 RTS



PLANES:   ;PEK!!!
 LEA REFLEXSIN,A4
 MOVE.L SCREENS(PC),A1
 MOVE.L A1,-(SP)
 MOVEQ #0,D6
 MOVEQ #31,D7
PLS1:
 LEA REFGRAF,A0
 ADD.W D6,A0
 MOVE.L (SP),A1

 MOVE.W (A4)+,D1
 MOVE.W D1,D0
 AND.W #15,D1
 AND.B #%11110000,D0
 LSR.W #1,D0
 ADD.W D0,A1
 LSL.W #7,D1
 LSL.W #2,D1    ;*512
 ADD.W D1,A0

 MOVEM.W (A0)+,D0-D5/A2-A3
 CLR.W -2(A1)
 MOVE.W D0,6(A1)
 MOVE.W D1,14(A1)
 MOVE.W D2,22(A1)
 MOVE.W D3,30(A1)
 MOVE.W D4,38(A1)
 MOVE.W D5,46(A1)
 MOVE.W A2,54(A1)
 MOVE.W A3,62(A1)
 CLR.W 70(A1)

 CLR.W -2+26880(A1)
 MOVE.W D0,6+26880(A1)
 MOVE.W D1,14+26880(A1)
 MOVE.W D2,22+26880(A1)
 MOVE.W D3,30+26880(A1)
 MOVE.W D4,38+26880(A1)
 MOVE.W D5,46+26880(A1)
 MOVE.W A2,54+26880(A1)
 MOVE.W A3,62+26880(A1)
 CLR.W 70+26880(A1)
 ADD.W #16,D6
 ADD.L #160,(SP)
 DBRA D7,PLS1
 ADDQ.W #4,SP

 MOVE.W (A4)+,D0
 BNE.S PLS2
   MOVE.L #REFLEXSIN,PLANES+2
PLS2:
 ADDQ.L #2,PLANES+2
 RTS


BLACKSPRITES:
 LEA BLACKS1(PC),A4
 MOVEQ #0,D0
 MOVEQ #5,D1
 BTST #0,CLOCK+1
 BNE.S BLSP1
   ADD.W #24,A4
BLSP1:
 MOVE.L (A4)+,A1
N@=0
L@=4
 REPEAT
   MOVE.L D0,L@(A1)
   MOVE.L D0,L@+8(A1)
N@=N@+1
L@=L@+160
 UNTILEQ N@,16
 DBRA D1,BLSP1
 RTS


SPRITES:
 LEA STALTAB(PC),A2
 MOVEQ #5,D0
SPR1:
 MOVE.W D0,-(SP)

 MOVE.L (A2)+,A0   ;GRAF
 MOVE.L (A2),A3    ;PEK ADDRESS

 MOVE.L SCREENS(PC),A1
 MOVE.W (A3)+,D1   ;X
 BNE.S SPR2
   LEA STALSIN(PC),A3
   MOVE.W (A3)+,D1
SPR2:
 MOVE.W D1,D0
 AND.W #15,D1
 AND.B #%11110000,D0
 LSR.W #1,D0
 ADD.W D0,A1
 ADD.W (A3)+,A1    ;Y
 MOVE.L A1,-(A4)   ;SAVE BLACK ADDRESS
 LSL.W #6,D1       ;*64
 ADD.W D1,A0

 MOVE.L A3,(A2)+
 JSR ONESPRITE(PC)

 MOVE.W (SP)+,D0
 DBRA D0,SPR1
 RTS

ONESPRITE:
 MOVEM.L (A0)+,D0-D7
 OR.L D0,4(A1)
 OR.L D1,12(A1)
 OR.L D0,4+160(A1)
 OR.L D1,12+160(A1)

 OR.L D2,4+320(A1)
 OR.L D3,12+320(A1)
 OR.L D2,4+480(A1)
 OR.L D3,12+480(A1)

 OR.L D4,4+640(A1)
 OR.L D5,12+640(A1)
 OR.L D4,4+800(A1)
 OR.L D5,12+800(A1)

 OR.L D6,4+960(A1)
 OR.L D7,12+960(A1)
 OR.L D6,4+1120(A1)
 OR.L D7,12+1120(A1)

 MOVEM.L (A0)+,D0-D7
 OR.L D0,4+1280(A1)
 OR.L D1,12+1280(A1)
 OR.L D0,4+1440(A1)
 OR.L D1,12+1440(A1)

 OR.L D2,4+1600(A1)
 OR.L D3,12+1600(A1)
 OR.L D2,4+1760(A1)
 OR.L D3,12+1760(A1)

 OR.L D4,4+1920(A1)
 OR.L D5,12+1920(A1)
 OR.L D4,4+2080(A1)
 OR.L D5,12+2080(A1)

 OR.L D6,4+2240(A1)
 OR.L D7,12+2240(A1)
 OR.L D6,4+2400(A1)
 OR.L D7,12+2400(A1)

 RTS
STALTAB:
 DC.L STALGRAF, STALSIN
 DC.L STALGRAF+1024, STALSIN+16
 DC.L STALGRAF+2048, STALSIN+32
 DC.L STALGRAF+3072, STALSIN+48
 DC.L STALGRAF+4096, STALSIN+64
 DC.L STALGRAF+5120, STALSIN+80


SINSTAB:
 DC.L FFY1,FFY2,FFY3,FFX1,FFX2,FFX3
FFADDTAB:
 DC.L FFGRAF,FFGRAF+192,FFGRAF+192*2,FFGRAF+192*3,FFGRAF+192*4
 DC.L FFGRAF+192*5,FFGRAF+192*6,FFGRAF+192*7,FFGRAF+192*8,FFGRAF+192*9
 DC.L FFGRAF+192*10,FFGRAF+192*11,FFGRAF+192*12,FFGRAF+192*13
 DC.L FFGRAF+192*14,FFGRAF+192*15
LOGO:
 MOVE.L SCREENS(PC),A1
   LEA SINSTAB(PC),A3
   MOVE.L (A3),A4
   MOVE.W (A4)+,D0
   BPL.S LG1
     LEA FFY1(PC),A4
     MOVE.W (A4)+,D0
LG1:
   MOVE.L A4,(A3)+
   ADD.W D0,A1
   MOVE.L (A3),A4
   MOVE.W (A4)+,D0
   BPL.S LG2
     LEA FFY2(PC),A4
     MOVE.W (A4)+,D0
LG2:
   MOVE.L A4,(A3)+
   ADD.W D0,A1
   MOVE.L (A3),A4
   MOVE.W (A4)+,D0
   BPL.S LG3
     LEA FFY3(PC),A4
     MOVE.W (A4)+,D0
LG3:
   MOVE.L A4,(A3)+
   ADD.W D0,A1

   MOVE.L (A3),A4
   MOVE.W (A4)+,D1
   BPL.S LG4
     LEA FFX1(PC),A4
     MOVE.W (A4)+,D1
LG4:
   MOVE.L A4,(A3)+
   MOVE.L (A3),A4
   MOVE.W (A4)+,D0
   BPL.S LG5
     LEA FFX2(PC),A4
     MOVE.W (A4)+,D0
LG5:
   MOVE.L A4,(A3)+
   ADD.W D0,D1
   MOVE.L (A3),A4
   MOVE.W (A4)+,D0
   BPL.S LG6
     LEA FFX3(PC),A4
     MOVE.W (A4)+,D0
LG6:
   MOVE.L A4,(A3)+
   ADD.W D0,D1

   MOVE.W D1,D0
   AND.W #15,D1
   AND.B #%11110000,D0
   LSR.W #1,D0
   ADD.W D0,A1
   LSL.W #2,D1
   LEA FFADDTAB(PC),A0
   MOVE.L (A0,D1.W),A0

 LEA BLTAB(PC),A2
 BTST #0,CLOCK+1
 BNE.S BFF2
  ADDQ.W #4,A2
BFF2:
 MOVE.L A1,(A2)

N@=0
L@=(55*160)+6
 REPEAT
   MOVEM.W (A0)+,D0-D7/A2
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+8(A1)
   MOVE.W D2,L@+16(A1)

   MOVE.W D3,L@+160(A1)
   MOVE.W D4,L@+168(A1)
   MOVE.W D5,L@+176(A1)

   MOVE.W D6,L@+320(A1)
   MOVE.W D7,L@+328(A1)
   MOVE.W A2,L@+336(A1)
N@=N@+1
L@=L@+480
 UNTILEQ N@,10
 RTS


BLACKFF:
 LEA BLTAB(PC),A0
 BTST #0,CLOCK+1
 BNE.S BFF1
  ADDQ.W #4,A0
BFF1:
 MOVE.L (A0),A1
 MOVEQ #0,D0
N@=0
L@=55*160+6
 REPEAT
   MOVE.W D0,L@(A1)
   MOVE.W D0,L@+8(A1)
   MOVE.W D0,L@+16(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,31
 RTS
BLTAB:
 DC.L SCR1,SCR2


SC2:
    LEA SCROLLSIN,A2
    MOVE.W (A2)+,D0
    BRA.S SC3
SCROLLS:
 LEA SCTAB(PC),A1
 MOVE.B #9,SCOUNT
SC1:
 LEA TEXTBUF,A0
   MOVE.L (A1),A2
   MOVE.W (A2)+,D0
   CMP.W #-40,D0
   BEQ.S SC2
SC3:
   MOVE.L A2,(A1)+
   ADD.W D0,A0
 MOVE.W (A1)+,D0
 MOVE.L A1,-(SP)

 MOVE.L SCREENS(PC),A1
 ADD.W D0,A1

N@=0
L@=8*160+4
X@=(187*160)+4
 REPEAT
   MOVEM.W (A0)+,D0-D7/A2-A4
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+160(A1)
   MOVE.W D2,L@+320(A1)
   MOVE.W D3,L@+480(A1)
   MOVE.W D4,L@+640(A1)
   MOVE.W D5,L@+800(A1)
   MOVE.W D6,L@+960(A1)
   MOVE.W D7,L@+1120(A1)
   MOVE.W A2,L@+1280(A1)
   MOVE.W A3,L@+1440(A1)
   MOVE.W A4,L@+1600(A1)

   MOVE.W D0,X@(A1)
   MOVE.W D1,X@-160(A1)
   MOVE.W D2,X@-320(A1)
   MOVE.W D3,X@-480(A1)
   MOVE.W D4,X@-640(A1)
   MOVE.W D5,X@-800(A1)
   MOVE.W D6,X@-960(A1)
   MOVE.W D7,X@-1120(A1)
   MOVE.W A2,X@-1280(A1)
   MOVE.W A3,X@-1440(A1)
   MOVE.W A4,X@-1600(A1)

N@=N@+1
L@=L@+(11*160)
X@=X@-(11*160)
 UNTILEQ N@,8

   MOVEM.W (A0)+,D0-D4
   MOVE.W D4,L@(A1)
   MOVE.W D3,L@+160(A1)
   MOVE.W D2,L@+320(A1)
   MOVE.W D1,L@+480(A1)
   MOVE.W D0,L@+640(A1)

   MOVE.W D4,X@(A1)
   MOVE.W D3,X@-160(A1)
   MOVE.W D2,X@-320(A1)
   MOVE.W D1,X@-480(A1)
   MOVE.W D0,X@-640(A1)

 MOVE.L (SP)+,A1
 SUBQ.B #1,SCOUNT
 BNE SC1

 RTS
SCOUNT: DC.W 0
SCTAB:
 DC.L SCROLLSIN
 DC.W 0
 DC.L SCROLLSIN+16
 DC.W 16
 DC.L SCROLLSIN+32
 DC.W 32
 DC.L SCROLLSIN+48
 DC.W 48
 DC.L SCROLLSIN+64
 DC.W 64
 DC.L SCROLLSIN+96
 DC.W 96
 DC.L SCROLLSIN+112
 DC.W 112
 DC.L SCROLLSIN+128
 DC.W 128
 DC.L SCROLLSIN+144
 DC.W 144


SS1:
   LEA TEXTBUF2+(15*(SPACE*7)),A0
   CMP.W #SPACE-40,SSPEK1+2
   BNE.S SS2
     MOVE.W #-2,SSPEK1+2
SS2:
   ADDQ.W #2,SSPEK1+2
   BRA.S SS3
SECONDSCROLL:  ;PEK!
 LEA TEXTBUF2+(15*(SPACE*7)),A0
 CMP.L #TEXTBUF2,A0
 BEQ.S SS1
 SUB.L #SPACE*7,A0
SS3:
 MOVE.L A0,SECONDSCROLL+2
SSPEK1:
   ADD.W #0,A0
 MOVE.L SCREENS(PC),A1
; LEA 164*160+6(A1),A4
 ADD.W #45*160+6,A1
 JSR GETDOWN(PC)

SSPEK2:
 LEA TEXTBUF2+(14*(SPACE*7)),A0
 CMP.L #TEXTBUF2,A0
 BEQ.S SS4
 SUB.L #(SPACE*7)*2,A0
SS6:
 MOVE.L A0,SSPEK2+2
SSPEK3:
   ADD.W #0,A0
 MOVE.L SCREENS(PC),A1
; LEA 180*160+6(A1),A4
 ADD.W #147*160+6,A1
 JSR GETDOWN(PC)

 RTS
SS4:
   LEA TEXTBUF2+(14*(SPACE*7)),A0
   CMP.W #SPACE-40,SSPEK3+2
   BNE.S SS5
     MOVE.W #-2,SSPEK3+2
SS5:
   ADDQ.W #2,SSPEK3+2
   BRA.S SS6


GETDOWN:
N@=0
L@=0
X@=0
 REPEAT
   MOVEM.W X@(A0),D0-D7/A2-A3
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+8(A1)
   MOVE.W D2,L@+16(A1)
   MOVE.W D3,L@+24(A1)
   MOVE.W D4,L@+32(A1)
   MOVE.W D5,L@+40(A1)
   MOVE.W D6,L@+48(A1)
   MOVE.W D7,L@+56(A1)
   MOVE.W A2,L@+64(A1)
   MOVE.W A3,L@+72(A1)

;   MOVE.W D0,L@(A4)
;   MOVE.W D1,L@+8(A4)
;   MOVE.W D2,L@+16(A4)
;   MOVE.W D3,L@+24(A4)
;   MOVE.W D4,L@+32(A4)
;   MOVE.W D5,L@+40(A4)
;   MOVE.W D6,L@+48(A4)
;   MOVE.W D7,L@+56(A4)
;   MOVE.W A2,L@+64(A4)
;   MOVE.W A3,L@+72(A4)


   MOVEM.W X@+20(A0),D0-D7/A2-A3
   MOVE.W D0,L@+80(A1)
   MOVE.W D1,L@+88(A1)
   MOVE.W D2,L@+96(A1)
   MOVE.W D3,L@+104(A1)
   MOVE.W D4,L@+112(A1)
   MOVE.W D5,L@+120(A1)
   MOVE.W D6,L@+128(A1)
   MOVE.W D7,L@+136(A1)
   MOVE.W A2,L@+144(A1)
   MOVE.W A3,L@+152(A1)

;   MOVE.W D0,L@+80(A4)
;   MOVE.W D1,L@+88(A4)
;   MOVE.W D2,L@+96(A4)
;   MOVE.W D3,L@+104(A4)
;   MOVE.W D4,L@+112(A4)
;   MOVE.W D5,L@+120(A4)
;   MOVE.W D6,L@+128(A4)
;   MOVE.W D7,L@+136(A4)
;   MOVE.W A2,L@+144(A4)
;   MOVE.W A3,L@+152(A4)
X@=X@+SPACE
N@=N@+1
L@=L@+160
 UNTILEQ N@,7
 RTS


FLEXSCREEN:
 MOVE.L SCREENS(PC),A1
FSPEK1:
 LEA FLEXTAB,A0
FSPEK2:
 LEA FLEXTAB+(50*8),A2
 MOVEQ #0,D5
 MOVEQ #-1,D6
 MOVE.W #160,D7
 MOVE.W #199,D4
FS1:
   MOVEM.W (A0)+,D0-D3
   MOVE.W D5,-8(A1,D0.W)
   MOVE.W D2,(A1,D0.W)
   MOVE.W D6,8(A1,D0.W)

   MOVE.W D6,-8(A1,D1.W)
   MOVE.W D3,(A1,D1.W)
   MOVE.W D5,8(A1,D1.W)

   MOVEM.W (A2)+,D0-D3
   MOVE.W D5,-6(A1,D0.W)
   MOVE.W D2,2(A1,D0.W)
   MOVE.W D6,10(A1,D0.W)

   MOVE.W D6,-6(A1,D1.W)
   MOVE.W D3,2(A1,D1.W)
   MOVE.W D5,10(A1,D1.W)

   ADD.W D7,A1
 DBRA D4,FS1

 MOVE.W (A0)+,D0
 CMP.W #-1,D0
 BNE.S FS2
    MOVE.L #FLEXTAB-8,FSPEK1+2
FS2:
 ADDQ.L #8,FSPEK1+2

ENDPEK:
 MOVE.L #0,D4

 MOVE.L FSPEK2+2,D0
 ADD.W #16,D0
 CMP.L D4,D0
 BLT.S FS3
   MOVE.L D0,D1
   SUB.L D4,D1
   MOVE.L #FLEXTAB,D0
   ADD.L D1,D0
FS3:
 MOVE.L D0,FSPEK2+2

 RTS


START:
 CLR.L -(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 MOVE.W #0,$484

 PEA MOUSE
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR1
 PEA SCR1
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA $FF8240,A1
 MOVEQ #7,D0
CLPAL:
 CLR.L (A1)+
 DBRA D0,CLPAL

 LEA SCR1,A0
 MOVE.W #9000,D0
CLS:
 MOVE.L #$FFFF0000,(A0)+
 CLR.L (A0)+
 DBRA D0,CLS

 BSR FIXTAB
 BSR CLEARBUF
 BSR MAKESCROLL
 BSR MAKESCROLL2
 BSR MAKESCROLL3
 BSR MAKEFF
 BSR MAKESTALIN
 BSR MAKEREFLEX
 BSR SINFIX
 BSR NOVIEW

 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVEQ #0,D0
 JSR MUSIC+42

 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
 BSR INITRAST
 MOVE.L #VBL,$70
 MOVE.W #$2300,SR
 JMP MAIN

EXIT:
 MOVE.W #$2700,SR
FLUSH:
 BTST #0,$FFFC00          ;IS A CHARACTER WAITING ?
 BEQ.S FL1                ;BR. IF NOT
 MOVE.B $FFFC02,D0        ;READ CHARACTER (& IGNORE IT)
 BRA.S FLUSH              ;CHECK FOR ANOTHER
FL1:
 BSR REMOVERAST
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR

 IFNE EXEC,-1
   MOVE.W #1,-(SP)
   PEA $F8000
   PEA $F8000
   MOVE.W #5,-(SP)
   TRAP #14
   ADD.L #12,SP
 ENDIF

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 IFEQ EXEC,-1
   CLR.W -(SP)
   TRAP #1
 ENDIF
 ILLEGAL
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS
MFP1:
 DC.W 0

CLEARBUF:
 LEA TEXTBUF(PC),A0
 MOVEQ #0,D0
 MOVE.W #24999,D1
CB:
 MOVE.L D0,(A0)+
 DBRA D1,CB
 RTS

INITRAST:
 LEA COLTAB+400(PC),A5
 LEA $FF8240,A6
 MOVE.L $120,SPAR2
 MOVE.B $FFFA09,SPAR4
 MOVE.B $FFFA07,SPAR4+1
 MOVE.B $FFFA13,SPAR4+2
 CLR.B $FFFA07
 CLR.B $FFFA09
 MOVE.L #RASTER1,$120
 ORI.B #1,$FFFA07
 ORI.B #1,$FFFA13
 RTS

REMOVERAST:
 MOVE.B SPAR4,$FFFA09
 MOVE.B SPAR4+1,$FFFA07
 MOVE.B SPAR4+2,$FFFA13
 MOVE.L SPAR2,$120
 RTS

RASTER1:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST1
 BCLR #0,$FFFA0F
 RTE
RST1:
 MOVE.L D0,-(SP)
 MOVE.L #$00500050,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #18,LCOUNT
 MOVE.L #RASTER15,$120
 BCLR #0,$FFFA0F
 RTE

RASTER15:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST15
 BCLR #0,$FFFA0F
 RTE
RST15:
 MOVE.L D0,-(SP)
 MOVE.L #$07170717,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #19,LCOUNT
 MOVE.L #RASTER2,$120
 BCLR #0,$FFFA0F
 RTE

LCOUNT:
 DC.B 16,0

RASTER2:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST2
 BCLR #0,$FFFA0F
 RTE
RST2:
 MOVE.L D0,-(SP)
 MOVE.L #$07770777,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #94,LCOUNT
 MOVE.L #RASTER3,$120
 BCLR #0,$FFFA0F
 RTE

RASTER3:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST3
 BCLR #0,$FFFA0F
 RTE
RST3:
 MOVE.L D0,-(SP)
 MOVE.L #$07170717,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #9,LCOUNT
 MOVE.L #RASTER4,$120
 BCLR #0,$FFFA0F
 RTE

RASTER4:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST4
 BCLR #0,$FFFA0F
 RTE
RST4:
 MOVE.L D0,-(SP)
 MOVE.L #$07610761,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #28,LCOUNT
 MOVE.L #RASTER5,$120
 BCLR #0,$FFFA0F
 RTE


RASTER5:
 MOVE.W (A5)+,(A6)
 SUBQ.B #1,LCOUNT
 BEQ.S RST5
 BCLR #0,$FFFA0F
 RTE
RST5:
 MOVE.L D0,-(SP)
 MOVE.L #$07000700,D0
 MOVE.L D0,16(A6)
 MOVE.L D0,20(A6)
 MOVE.L D0,24(A6)
 MOVE.L D0,28(A6)
 MOVE.L (SP)+,D0
 MOVE.B #16,LCOUNT
 MOVE.L #RASTERLAST,$120
 BCLR #0,$FFFA0F
 RTE


RASTERLAST:
 MOVE.W (A5)+,(A6)
 BCLR #0,$FFFA0F
 RTE


NOVIEW:
 MOVE.W #299,D0
NV1:
 MOVE.W D0,-(SP)
   MOVE.L SCREENS(PC),D0
   MOVE.L SCREENS+4(PC),D1
   EXG.L D0,D1
   MOVE.L D0,SCREENS
   MOVE.L D1,SCREENS+4
   JSR FLEXSCREEN(PC)
 MOVE.W (SP)+,D0
 DBRA D0,NV1
 RTS


FIXTAB:
 LEA FLEXTAB(PC),A2
 LEA FLEXTAB+30000,A3
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVE.W #(FLEXEND-FLEXTAB)/4,D0
 BSR COPY

 MOVE.W #199,D0
FT3:
 MOVE.L #$00280070,(A2)+
 MOVE.L #-1,(A2)+
 DBRA D0,FT3

FT2:
   CLR.W D0
   MOVE.B (A3)+,D0
   CMP.B #255,D0
   BEQ.S FT5
   MOVE.W D0,D1
   AND.B #%11110000,D0
   LSR.W #1,D0
   MOVE.W D0,(A2)+
   MOVE.W #152,D2
   SUB.W D0,D2
   MOVE.W D2,(A2)+
   AND.W #15,D1
   LSL.W #2,D1
   MOVE.L FTTAB(PC,D1.W),(A2)+
   BRA.S FT2
FT5:

 MOVE.W #199,D0
FT4:
 MOVE.L #$00280070,(A2)+
 MOVE.L #-1,(A2)+
 DBRA D0,FT4

 MOVE.W #-1,(A2)+   ;SIGNAL TABEL END
 SUB.L #2+(200*8),A2
 MOVE.L A2,ENDPEK+2    ;SAVE END FOR LATER USE
 RTS
FTTAB:
 DC.W 65535,65535 ,32767,65534 ,16383,65532, 8191,65528, 4095,65520, 2047,65504, 1023,65472, 511,65408
 DC.W 255,65280, 127,65024, 63,64512, 31,63488, 15,61440, 7,57344, 3,49152, 1,32768


MAKESCROLL:
 LEA FATFONT(PC),A0
 LEA ASCII(PC),A1
 LEA TEXTBUF,A2

MS1:
 CLR.W D0
 MOVE.B (A1)+,D0
 BEQ.S MSFIN
 SUB.B #32,D0
 LSL.W #5,D0
 LEA (A0,D0.W),A3
 MOVEM.L (A3),D0-D7
 MOVEM.L D0-D7,(A2)
 ADD.W #32,A2
 BRA.S MS1

MSFIN:
 RTS


MAKESCROLL3:
 LEA ASCII3(PC),A0
 LEA FONT2(PC),A1
 LEA TEXTBUF3,A3
MS33:
 MOVEQ #0,D0
 MOVE.B (A0)+,D0
 BEQ.S MSFIN3
  SUB.B #32,D0
  LSL.W #3,D0
  LEA (A1,D0.W),A2
  MOVE.L (A2)+,(A3)+
  MOVE.L (A2)+,(A3)+
 BRA.S MS33
MSFIN3:
 MOVE.L A3,EPEK1+2     ;SAVE END ADDRESS
 RTS


MAKESCROLL2:
 LEA ASCII2(PC),A0
 LEA FONT2(PC),A1
 LEA TEXTBUF2,A3
MS2:
 MOVEQ #0,D0
 MOVE.B (A0)+,D0
 BEQ.S MSFIN2
  SUB.B #32,D0
  LSL.W #3,D0
  LEA (A1,D0.W),A2
  MOVE.B (A2)+,(A3)
  MOVE.B (A2)+,SPACE(A3)
  MOVE.B (A2)+,SPACE*2(A3)
  MOVE.B (A2)+,SPACE*3(A3)
  MOVE.B (A2)+,SPACE*4(A3)
  MOVE.B (A2)+,SPACE*5(A3)
  MOVE.B (A2)+,SPACE*6(A3)
  ADDQ.W #1,A3
  BRA.S MS2
MSFIN2:

 LEA TEXTBUF2,A2
 LEA TEXTBUF2+(SPACE*7),A3
 MOVEQ #15,D2               ;16 ROTATIONS
MS4:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVE.W #(SPACE*7)/4-1,D0
 BSR COPY
 MOVE.L A3,A1
 MOVEQ #6,D1                ;7 LINES
MS3:
   MOVE.L A1,A0
   MOVE.W #(SPACE/2)-1,D0   ;ONE ROW
MS5:
   ROXR.W (A0)+
   DBRA D0,MS5
   LEA SPACE(A1),A1
 DBRA D1,MS3
 MOVE.L A3,A2
 ADD.W #SPACE*7,A3
 DBRA D2,MS4
 RTS


MAKEFF:
 LEA FFDAT(PC),A0
 LEA FFGRAF,A1
 MOVEQ #31,D0
MFF1:
 MOVE.L (A0)+,(A1)+
 CLR.W (A1)+
 DBRA D0,MFF1

 LEA FFGRAF,A2
 LEA 192(A2),A3
 MOVEQ #14,D1
MFF3:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVEQ #192/4-1,D0
 BSR COPY
 MOVE.L A3,A0
 MOVEQ #31,D0
MFF2:
   MOVE #0,CCR
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
 DBRA D0,MFF2
 MOVE.L A3,A2
 ADD.W #192,A3
 DBRA D1,MFF3
 RTS


MAKESTALIN:
 LEA STALINDAT(PC),A0
 MOVE.W #%0111111111111110,64+18(A0)   ;MAKE "A" LOOK BETTER
 LEA STALGRAF,A1
 MOVEQ #0,D0

 MOVEQ #5,D2
MST2:
   MOVEQ #7,D1
MST1:
   MOVE.L (A0)+,(A1)+
   MOVE.L D0,(A1)+
   DBRA D1,MST1
 ADD.W #15*64,A1
 DBRA D2,MST2

 LEA STALGRAF,A2
 LEA 64(A2),A3

 MOVEQ #5,D2
MST5:
 MOVEQ #14,D1
MST3:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVEQ #64/4-1,D0
 BSR COPY
 MOVE.L A3,A0
 MOVEQ #7,D0
MST4:
   MOVE #0,CCR
   ROXR.W (A0)
   ROXR.W 4(A0)
   MOVE #0,CCR
   ROXR.W 2(A0)
   ROXR.W 6(A0)
   ADDQ.W #8,A0
 DBRA D0,MST4
 MOVE.L A3,A2
 ADD.W #64,A3
 DBRA D1,MST3
 ADD.W #64,A2
 ADD.W #64,A3
 DBRA D2,MST5
 RTS


MAKEREFLEX:
 LEA REFLEXDAT(PC),A0
 LEA REFGRAF,A1
 MOVE.W #512/4-1,D0
 BSR COPY

 LEA REFGRAF,A2
 LEA 512(A2),A3
 MOVEQ #14,D1
MRX3:
 MOVE.L A2,A0
 MOVE.L A3,A1
 MOVEQ #512/4-1,D0
 BSR COPY
 MOVE.L A3,A0
 MOVEQ #31,D0
MRX2:
   MOVE #0,CCR
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
   ROXR.W (A0)+
 DBRA D0,MRX2
 MOVE.L A3,A2
 ADD.W #512,A3
 DBRA D1,MRX3
 RTS


SINFIX:
 LEA STALSIN(PC),A0
SFFX1:
 MOVE.W (A0),D0
 BEQ.S SFFX2
 ADDQ.W #4,A0
 CMP.W #303,D0
 BLO.S SFFX1
 MOVE.W #303,-4(A0)
 BRA.S SFFX1
SFFX2:
 RTS


ASCII:
 DS.B 6,' '
 DC.B "STALIN OF FLEXIBLE FRONT PRESENTS THE VERY STRANGE SCREEN "
 DC.B "WITH VERY UGLY SINE WAVES. EVERYTHING MADE BY MYSELF AND "
 DC.B "NOONE ELSE. NOONE! NYYAAAGGGHHHHH!!!! (THIS IS HOW YOU BECOME "
 DC.B "AFTER A WHILE WHEN YOU HAVE MADE TOO MANY DEMOS)      WRUP...   "
 DS.B 6,' '
 DC.B 0
ASCEND:

ASCII2:
 DS.B 40," "
 DC.B "THIS IS THE SECOND SCROLLTEXT IN THIS DEMO."
 DC.B " BLIMEY, IT WORKS TOO!   SOWATT DA HECK...   WHO CARES ANYWAY?   "
 DC.B " HELLO TO -AN COOL-, THE ADDICT. (LIAR!)     "
 DC.B " THIEVES AND LIARS!!! HIPPOCRITS AND BASTARDS!!!"
 DC.B " THIS SCREEN IS CALLED 'BITPLANOMANIAINSANIA'. "
 DC.B " DO I WIN THE CONTEST?           "
 DC.B " AS ALWAYS TO THE GREEN GUY...     "
 DC.B "    LET'S WOOOOOOOOORP...    "
 DS.B 40," "
 DC.B 0

ASCII3:
 DS.B 24," "
 DC.B "WHAT TO DO WHEN THERE ARE RASTERTIME LEFT BUT NO IDEAS? "
 DC.B "YOU ADD SOME MORE STUPID LITTLE SCROLLERS, THAT'S WHAT YOU DO! "
 DC.B "THIS SCREEN HAS BECOME EVEN MORE UGLIER THAN I EXPECTED, THAT'S "
 DC.B "IS THE ONLY POSSIBLE RESULT WHEN I MAKE ALL THE GRAFIX AND "
 DC.B "COLOR DESIGN MYSELF. "
 DC.B "TODAY IS THE FIFTH OF AUGUST AND THIS SCREEN MUST BE FINISHED "
 DC.B "IF THE REFLEX DEMO IS TO BE RELEASED THIS YEAR. VOGON POETRY "
 DC.B "FAN CLUB'S ANNUAL MEETING ENDED UP (AS EXPECTED) IN TOTAL CHAOS."
 DC.B "                                        ...FORTYTWO"
 DS.B 24," "
 DC.B 0
 ALIGN.W

OKEY: DC.L 0,0
OHBL: DC.L 0
SPAR: DS.L 8,0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0
OMFP:
 DC.W 0
COLTAB:

N@=0
 REPEAT
 DC.W $000,$000,$000
 DC.W $001,$100,$100
 DC.W $002,$200,$200
 DC.W $003,$300,$300
 DC.W $004,$400,$400
 DC.W $005,$500,$500
 DC.W $006,$600,$600
 DC.W $007,$700,$700
 DC.W $007,$700,$700
 DC.W $006,$600,$600
 DC.W $005,$500,$500
 DC.W $004,$400,$400
 DC.W $003,$300,$300
 DC.W $002,$200,$200
 DC.W $001,$100,$100
 DC.W $000,$000,$000

 DC.W 0,0

 DC.W $000,$000,$000
 DC.W $110,$010,$010
 DC.W $220,$020,$020
 DC.W $330,$030,$030
 DC.W $440,$040,$040
 DC.W $550,$050,$050
 DC.W $660,$060,$060
 DC.W $770,$070,$070
 DC.W $770,$070,$070
 DC.W $660,$060,$060
 DC.W $550,$050,$050
 DC.W $440,$040,$040
 DC.W $330,$030,$030
 DC.W $220,$020,$020
 DC.W $110,$010,$010
 DC.W $000,$000,$000

 DC.W 0,0
N@=N@+1
 UNTILEQ N@,4


PAL:
 DC.W $000,$070,$007,$007,$557,$557,$007,$007
 DC.W $717,$717,$717,$717,$717,$717,$717,$717
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

MOUSE:
 DC.B $12,$1A,$14,8

SCREENS:
 DC.L SCR1,SCR2

CLOCK:
 DC.W 0,0

MUSIC:
 IBYTES VERMIN.MUS

SCROLLSIN:
 IBYTES SCROLLS.SIN
 DS.W 10,0
 DC.W -40

STALINDAT:
 IBYTES STALIN.DAT

FFDAT:
 IBYTES FF.DAT

FFY1:
 IBYTES FFY1.SIN
 DC.W -1
FFY2:
 IBYTES FFY2.SIN
 DC.W -1
FFY3:
 IBYTES FFY3.SIN
 DC.W -1
FFX1:
 IBYTES FFX1.SIN
 DC.W -1
FFX2:
 IBYTES FFX2.SIN
 DC.W -1
FFX3:
 IBYTES FFX3.SIN
 DC.W -1

BLACKS1:
 DS.L 12,SCR1

FATFONT:
 IBYTES SMALLFNT.DAT

FONT2:
 IBYTES SYSFONT.DAT

STALSIN:
 IBYTES STALIN.SIN
 DC.W 0

REFLEXDAT:
 IBYTES REFLEX.DAT

REFLEXSIN:
 DS.W 32,96
 IBYTES REFLEX.SIN
 DS.W 32,96
 DC.W 0

FLEXTAB:
 IBYTES FLEX.SIN
 DC.B 255
 ALIGN.W
FLEXEND:

TEXTBUF EQU FLEXTAB+10000
TEXTBUF2 EQU FLEXTAB+30000
FFGRAF EQU FLEXTAB+100000    ;3072 BYTES
STALGRAF EQU FLEXTAB+104000  ;6144
REFGRAF EQU FLEXTAB+111000   ;8192
TEXTBUF3 EQU FLEXTAB+120000
 END

 